//
//  MCModelListFilter.h
//  MCApplication
//
//  Created by aj on Fri Nov 30 2001.
//  Copyright (c) 2001 __MyCompanyName__. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "MCWindowController.h"

@interface MCModelListFilter : MCWindowController {
	
	id			delegate;

    id			okButton;
    id			cancelButton;
	
	id			(amd);	// not retained
	id			(messageField); // not retained
	
}

- (IBAction)ok:(id)sender;
- (IBAction)cancel:(id)sender;

- (id)delegate;
- (void)setDelegate:(id)aDeleg;

// amd and messageField are only valid if runSheetForAMD:: is invoked and before the sheetDidEnd:
- (id)amd;
- (id)messageField;

- (void)runSheetForAMD:(id)anAMD messageField:(id)aTextField;

- (void)runSheetInWindow:(NSWindow *)aWindow;
- (void)modelFilterSheetDidEnd:(NSWindow *)sheet 
    returnCode:(int)returnCode contextInfo:(void *)contextInfo;
	
// Gives subclassers the opportunity to package the instruction to pass to the delegate when the user clicks OK
- (id)filterInstructions;

// Gives subclassers the opportunity to display instruction when the sheet is run -- call this before runSheetInWindow:
- (void)populateUsingInstructions:(id)instructions;

@end


@interface NSObject (MCModelListFilterDelegate)
- (void)modelListFilterDidOk:(MCModelListFilter *)aFilter filterInstructions:(id)instructions;
- (void)modelListFilterDidCancel:(MCModelListFilter *)aFilter filterInstructions:(id)instructions;

@end
